var SORT_COLUMN_INDEX;

function makeStripe(thisTbl)
{
	if (!thisTbl.getElementsByTagName)
		return;

	rows = thisTbl.getElementsByTagName("tr");

	var n=0;
	for(var i=1; i<rows.length; i++)
	{
		if ((' '+rows[i].id+' ').indexOf("skip_striping") != -1)
			continue;
		rows[i].className = ((n%2)==0 ? "row_odd" : "row_even");
		n++;
	}
}

function ts_makeSortable(table)
{
	if (table.rows && table.rows.length > 0)
		var firstRow = table.rows[0];

	if (!firstRow)
		return;
	
	// We have a first row: assume it's the header, and make its contents clickable links
	for (var i=0; i<firstRow.cells.length; i++)
	{
		var cell = firstRow.cells[i];
		if(cell.className.indexOf("unsort")==-1)
		{		
//			var txt = ts_getInnerText(cell);
//			cell.innerHTML = '<a href="#" onclick="ts_resortTable2(this);return false;">'+txt+'<span class="sortarrow"></span></a>';
			addEvent(cell, "onclick", ts_resortTable2(cell));
		}
	}
}

function ts_getInnerText(el)
{
	if (typeof el == "string")
		return el;

	if (typeof el == "undefined") { return el };

	if (el.innerText)
		return el.innerText;	//Not needed but it is faster

	var str = "";	
	var cs = el.childNodes;
	var l = cs.length;

	for (var i = 0; i < l; i++)
	{
		switch (cs[i].nodeType)
		{
			case 1: //ELEMENT_NODE
	 			str += ts_getInnerText(cs[i]);
 			break;
			case 3:	//TEXT_NODE
				str += cs[i].nodeValue;
			break;
		}
	}
	return str;
}

function ts_resortTable(lnk) {
	var span;

	for (var ci=0; ci<lnk.childNodes.length; ci++)
		if (lnk.childNodes[ci].tagName && lnk.childNodes[ci].tagName.toLowerCase() == 'span')
			span = lnk.childNodes[ci];

	var spantext = ts_getInnerText(span);
	var td = lnk.parentNode;
	var column = td.cellIndex;
	var table = getParent(td,'TABLE');
		
	// Work out a type for the column
	if (table.rows.length <= 1)
		return;

	var itm = ts_getInnerText(table.rows[1].cells[column]);
	sortfn = ts_sort_caseinsensitive;

	if (itm.match(/^[\d\.-]+$/))
		sortfn = ts_sort_numeric;

	SORT_COLUMN_INDEX = column;

	var firstRow = new Array();
	var newRows = new Array();

	for (i=0;i<table.rows[0].length;i++) 
		firstRow[i] = table.rows[0][i];

	for (j=1;j<table.rows.length;j++) 
		newRows[j-1] = table.rows[j]; 

	newRows.sort(sortfn);

	if (span.getAttribute("sortdir") == 'down')
	{
		newRows.reverse();
		span.setAttribute('sortdir','up');
	}
	else
		span.setAttribute('sortdir','down');
		
	// We appendChild rows that already exist to the tbody, so it moves them rather than creating new ones
	// don't do sortbottom rows
	for (i=0; i<newRows.length; i++) 
		if (!newRows[i].className || (newRows[i].className && (newRows[i].className.indexOf('sortbottom') == -1)))
			table.tBodies[0].appendChild(newRows[i]);

	// do sortbottom rows only
	for (i=0; i<newRows.length; i++)
		if (newRows[i].className && (newRows[i].className.indexOf('sortbottom') != -1))
			table.tBodies[0].appendChild(newRows[i]);

	makeStripe(table);
}

function ts_resortTable2(td) {
//	var span;

//	for (var ci=0; ci<lnk.childNodes.length; ci++)
//		if (lnk.childNodes[ci].tagName && lnk.childNodes[ci].tagName.toLowerCase() == 'span')
//			span = lnk.childNodes[ci];

//	var spantext = ts_getInnerText(span);
//	var td = lnk.parentNode;
	var column = td.cellIndex;
	var table = getParent(td,'TABLE');
		
	// Work out a type for the column
	if (table.rows.length <= 1)
		return;

	var itm = ts_getInnerText(table.rows[1].cells[column]);
	sortfn = ts_sort_caseinsensitive;

	if (itm.match(/^[\d\.-]+$/))
		sortfn = ts_sort_numeric;

	SORT_COLUMN_INDEX = column;

	var firstRow = new Array();
	var newRows = new Array();

	for (i=0;i<table.rows[0].length;i++) 
		firstRow[i] = table.rows[0][i];

	for (j=1;j<table.rows.length;j++) 
		newRows[j-1] = table.rows[j]; 

	newRows.sort(sortfn);


	if (td.getAttribute("sortdir") == 'down')
	{
		newRows.reverse();
		td.setAttribute('sortdir','up');
	}
	else
		td.setAttribute('sortdir','down');

		
	// We appendChild rows that already exist to the tbody, so it moves them rather than creating new ones
	// don't do sortbottom rows
	for (i=0; i<newRows.length; i++) 
		if (!newRows[i].className || (newRows[i].className && (newRows[i].className.indexOf('sortbottom') == -1)))
			table.tBodies[0].appendChild(newRows[i]);

	// do sortbottom rows only
	for (i=0; i<newRows.length; i++)
		if (newRows[i].className && (newRows[i].className.indexOf('sortbottom') != -1))
			table.tBodies[0].appendChild(newRows[i]);

	makeStripe(table);
}

function getParent(el, pTagName)
{
	if (el == null)
		return null;
	else if (el.nodeType == 1 && el.tagName.toLowerCase() == pTagName.toLowerCase())	// Gecko bug, supposed to be uppercase
		return el;
	else
		return getParent(el.parentNode, pTagName);
}

function ts_sort_numeric(a,b)
{ 
	aa = parseFloat(ts_getInnerText(a.cells[SORT_COLUMN_INDEX]));
	if (isNaN(aa))
		aa = 0;
	bb = parseFloat(ts_getInnerText(b.cells[SORT_COLUMN_INDEX])); 

	if (isNaN(bb))
		bb = 0;

	return aa-bb;
}

function ts_sort_caseinsensitive(a,b)
{
	aa = ts_getInnerText(a.cells[SORT_COLUMN_INDEX]).toLowerCase();
	bb = ts_getInnerText(b.cells[SORT_COLUMN_INDEX]).toLowerCase();

	if (aa==bb)
		return 0;
	if (aa<bb)
		return -1;

	return 1;
}

function ts_sort_default(a,b)
{
	aa = ts_getInnerText(a.cells[SORT_COLUMN_INDEX]);
	bb = ts_getInnerText(b.cells[SORT_COLUMN_INDEX]);
	if (aa==bb)
		return 0;
	if (aa<bb)
		return -1;

	return 1;
}

function addEvent(element, eventType, func, useCapture)
{
/*	if (element.addEventListener)
	{
		element.addEventListener(eventType, func, useCapture);
		return true;
	} 
	else if (element.attachEvent)
	{
		var r = element.attachEvent("on"+eventType, func);
		return r;
	}*/
}

//addEvent(window, "load", sortables_init, false);

function sortables_init()
{
	// Find all tables with class sortable and make them sortable
	if (!document.getElementsByTagName)
		return;

	tbls = document.getElementsByTagName("table");

	for (ti=0; ti<tbls.length; ti++)
	{
		thisTbl = tbls[ti];
		if (((' '+thisTbl.className+' ').indexOf("sortable") != -1) && (thisTbl.id))
		{
			ts_makeSortable(thisTbl);
			makeStripe(thisTbl);
		}
	}
}